local mainButtonFont = "_francophilsans Bold 24px"
return Def.ActorFrame{
	Def.ActorFrame{
		Name="MainButtons";
		InitCommand=cmd(xy,SCREEN_CENTER_X+48,SCREEN_CENTER_Y-148;);
		BeginCommand=function(self)
			local c = self:GetChildren()
			c.ButtonAdd:playcommand("GainFocus")
			c.ButtonEdit:playcommand("LoseFocus")
			c.ButtonDelete:playcommand("LoseFocus")
		end;
		MainMenuMoveMessageCommand=function(self,p)
			local old, new = p.Old, p.New
			local c = self:GetChildren()
			c.ButtonAdd:playcommand(new == 1 and "GainFocus" or "LoseFocus")
			c.ButtonEdit:playcommand(new == 2 and "GainFocus" or "LoseFocus")
			c.ButtonDelete:playcommand(new == 3 and "GainFocus" or "LoseFocus")
		end;

		Def.ActorFrame{
			Name="ButtonAdd";
			InitCommand=cmd(x,-108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Add");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="ButtonEdit";
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Edit");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
		Def.ActorFrame{
			Name="ButtonDelete";
			InitCommand=cmd(x,108;);
			GainFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("GainFocus")
			end;
			LoseFocusCommand=function(self)
				local button = self:GetChild("Button")
				local text = self:GetChild("Text")
				text:playcommand("LoseFocus")
			end;

			LoadActor(THEME:GetPathG("_speedmod","mainitem"))..{
				Name="Button";
				GainFocusCommand=cmd(diffuse,color("1,0.95,0.9,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.625"));
			};
			LoadFont(mainButtonFont)..{
				Name="Text";
				InitCommand=cmd(shadowlength,1.5;zoom,16/24);
				BeginCommand=cmd(settext,"Delete");
				GainFocusCommand=cmd(diffuse,color("1,0.8,0.2,1"));
				LoseFocusCommand=cmd(diffuse,color("1,1,1,0.8"));
			};
		};
	};
};